import { Repository } from 'typeorm';
import { Vendor } from '../../entities/vendor.entity';
import { User } from '../../entities/user.entity';
import { Product } from '../../entities/product.entity';
import { Order } from '../../entities/order.entity';
import { CreateProductDto, UpdateProductDto, UpdateVendorStatusDto } from './dto/dto';
export declare class AdminService {
    private readonly vendorRepo;
    private readonly userRepo;
    private readonly productRepo;
    private readonly orderRepo;
    constructor(vendorRepo: Repository<Vendor>, userRepo: Repository<User>, productRepo: Repository<Product>, orderRepo: Repository<Order>);
    getAllVendors(): Promise<Vendor[]>;
    getVendorById(id: string): Promise<Vendor>;
    updateVendorStatus(id: string, updateVendorStatusDto: UpdateVendorStatusDto): Promise<Vendor>;
    getDashboardStats(): Promise<{
        totals: {
            vendors: number;
            customers: number;
            products: number;
            orders: number;
            pendingVendors: number;
        };
        recentOrders: Order[];
        chartData: {
            orders: any[];
        };
    }>;
    private getChartData;
    createProduct(createProductDto: CreateProductDto): Promise<Product[]>;
    updateProduct(id: string, updateProductDto: UpdateProductDto): Promise<Product>;
    deleteProduct(id: string): Promise<void>;
    getPendingVendors(): Promise<Vendor[]>;
    approveVendor(id: string, notes?: string): Promise<Vendor>;
    rejectVendor(id: string, reason: string): Promise<Vendor>;
    getAllUsers(): Promise<User[]>;
    getUserById(id: string): Promise<User>;
    updateUserRole(id: string, role: string): Promise<User>;
}
